//LidPostNoHole.scad

//Module to define one post attached to the 
//lid for the screw that fastens the lid 
//to the floor; 

//This module makes the body of the 
//post, without the hole for the screw;
//It is theoretically possible to do 
//the job in one module, but the peculiar 
//syntax of OpenSCAD thwarted my attempts 
//to do that, so I use two modules, 
//one for the body and one for the hole;

//The body of the post is made from two parts:
//1:
//A cylinder, with a hole for a screw;
//2:
//A cube to fill the space between that 
//cylinder and the wall to which it is attached;

//The module accepts one input parameter:
//WallDeltaY;
//For the two posts on the front wall, 
//WallDeltaY = -PostLidPhi/2;
//For the two posts on the rear wall, 
//WallDeltaY = +PostLidPhi/2;
//This places the cube of the post on 
//the appropriate side of the cylinder 
//to simplify translation from the origin 
//to the appropriate wall;
//This is a little bit helpful, 
//but only a little bit helpful;

//On output from this module, 
//the cylinder, is centered about the Z axis, 
//and rests on the XY plane;
//The cube is displaced from the cylinder 
//by half its diameter;  
//The displacement is in the Y direction 
//specified by the parameter: WallDeltaY,
//as described above;

//Any further adjustment of 
//orientation and/or position must be done 
//by the calling module;

include <UNO_Dimensions.scad>;

module LidPostNoHole(WallDeltaY)
{

echo("Begin LidPostNoHole");
    
//WallDeltaY = PostLidPhi/2;
        
    translate([0, 0, PostLidHeight/2])
    cylinder(h=PostLidHeight,
        d=PostLidPhi, 
        center=true, $fn=32);

    translate([0, WallDeltaY, 
        PostLidHeight/2])
    cube([PostLidPhi, PostLidPhi, 
        PostLidHeight], center=true);

}

//
